# Testprogramm fuer SWR-Meter, Version1300W vom  11.02.2022
#main10.py
import TFT24
import machine
from machine import Pin, SPI, ADC
import time
import ili9341
#import math
Max=1300
spi = machine.SPI(2, baudrate = 64000000)
spi = SPI(mosi=Pin(23), sck=Pin(18), miso=Pin(19))
display= ili9341.ILI9341(spi, cs=machine.Pin(5), dc=machine.Pin(33), rst=machine.Pin(14), width=240, height=320)
tft=TFT24.TFTDisplay(240,320,display)   # Eine Instanz (Objekt) der Klasse Clear wird angelegt
tft.Clr()     # Start der Eigenschaft (Funktion) ClearDisp
tft.Fill(0,0,0)
adcv=ADC(Pin(34))
adcr=ADC(Pin(36))
adctemp=ADC(Pin(35))
ven1 = Pin(19,Pin.OUT)
ven2 = Pin(4,Pin.OUT)
BlueLED=Pin(2,Pin.OUT)
flagv=1    # Flag: V-Aktion!
flagvb=1   # Aktion Balken ändern
flagr=1    # Flag: R-Aktion!
flagtemp=1  # Flag Temperaturänderung
flag1=0
flag1old=0
flag2=0
flag2old=0
xvwold=0  # x-Wert des Balkens fuer Vorwaerts-old
dwvold=0
dwrold=0
dtempold=0
dwv=1
dwr=0
dtemp=0
temp=adctemp.read()/4096*1000
swr=1    # SWR-Wert
n=1      # Anzahl der Durchschnittswerte
rt=0     # Farbe Rot
gn=255     # Farbe Gruen
bl=0     # Farbe Blau
tft.Ptz1(0,0,"DL5DSM",0,255,0)
tft.Ptz3(0,1,"FWD:",255,255,255)
tft.Ptz3(9,1,"TEMP:",255,255,255)
tft.Ptz3(0,7,"REF:",255,255,255)
tft.Ptz3(9,7,"SWR:",255,255,255)
tft.Ptx1(60,150,"250mV",0,255,0)
tft.Ptx1(140,150,"500mV",0,255,0)
tft.Ptx1(220,150,"750mV",0,255,0)
tft.Ptx1(275,150,"1000mV",0,255,0)
Maxformat="{:4.0f}W"
tft.Ptx1(60,90,Maxformat.format(Max/16),0,255,0)  # Anzeigen des Temperaturwe
tft.Ptx1(140,90,Maxformat.format(Max/4),0,255,0)  # Anzeigen des Temperaturwe
tft.Ptx1(220,90,Maxformat.format(Max*9/16),0,255,0)  # Anzeigen des Temperaturwe
tft.Ptx1(280,90,Maxformat.format(Max),0,255,0)  # Anzeigen des Temperaturwe

ven1.value(0) # Beide Ventilatoren aus
ven2.value(0)

while True:
    BlueLED.value(0)
    for i in range (10):
        ewvn= adcv.read()/4096*1000
        ewrn= adcr.read()/4096*1000
        temp=adctemp.read()/4096*1000
        dwv=(dwv+ewvn)/2
        dwr=(dwr+ewrn)/2
        dtemp=(dtemp*10+temp)/11
        #time.sleep_ms(5)
    if (dwv >=1):               # Eine Neuberechnung erfolgt nur, wenn ein Signal anliegt
        swr=(dwv+dwr)/(dwv-dwr)
    if swr<=1.5:
        gn=255
        rt=0
        bl=0
    if swr>1.5:
        gn=255
        rt=255
        bl=0
    if swr>3:
        gn=0
        rt=255
        bl=0
    
    if ((dwv <= dwvold-10) or (dwv >= dwvold+10)):
        flagv=1
    
    if ((dwv <= dwvold-3) or (dwv >= dwvold+3)):
        flagvb=1    
    
    if ((dwr <= dwrold-10) or (dwr >= dwrold+10)):
        flagr=1
        
    if ((dtemp<=dtempold-5) or (dtemp>=dtempold+5)):
        flagtemp=1
        
    if ((flagv>=1) or (flagr>=1) or (flagtemp>=1)):  #Jede Aktion wird mit Pin2(Blaue LED) quittiert
        BlueLED.value(1)
        
    if ((flagvb == 1) or (flagr ==1)):    
        xvw=int(dwv/1024*320)
        if (xvw<=xvwold):                  #Kuerzen des Balkens   
            tft.Fra(xvw,100,(319-xvw),50,0,0,0)
        tft.Fra(0,100,xvw,50,rt,gn,bl)      #Verlaengern des Balkens
        xvwold=xvw
        
        
    if (flagv == 1):
        tft.Fra(60,239,93,49,0,0,50)      #Loeschen des alten Vorwaerts-Zahlenwertes
        vw="{:4.0f}W"
        adwv=dwv/1000*dwv/1000*Max
        tft.Ptz3(4,1,vw.format(adwv),255,255,255) #Anzeigen des FWD-Wertes
        fmV="{:4.0f}mV"
        tft.Ptz2(6,0,fmV.format(dwv),255,255,255)
        dwvold = dwv       # als Durchschnittswert wird der alte Meßwert genommen
        flagv=0
        
    if (flagr == 1):     
        tft.Fra(50,3,110,50,0,0,50)      #Loeschen des alten dwr/adwr-Wertes
        tft.Fra(319,23,100,30,0,0,50)      #Loeschen des alten swr-Wertes
        frws="{:4.0f}mV"
        tft.Ptz2(4,12,frws.format(dwr),255,255,255)
        
        adwr=(dwr/1000)*(dwr/1000)*Max
        frw="{:3.1f}W"
        tft.Ptz3(3,7,frw.format(adwr),255,255,255)
        
        fswr="{:1.3f}"
        tft.Ptz3(13,7,fswr.format(swr),255,255,255)
        dwrold = dwr
        flagr=0
        
    if (flagtemp==1):
        tft.Fra(319,239,75,49,0,0,50)         #Loeschen des alten Temperatur-Zahlenwertes
        atemp=(9.8*(dtemp+34))**0.50
        if (atemp<50):
            rt=0
            gn=255
            bl=0
        if (atemp>=50):
            ven1.value(1)
            flag1=1
            rt=255
            gn=255
            bl=0
        if (atemp<40):
            ven1.value(0)
            flag1=0
        if (atemp>=70):
            ven2.value(1)
            flag2=1
            rt=255
            gn=0
            bl=0
        if (atemp<=60):
            ven2.value(0)
            flag2=0
        
        tempformat="{:2.0f}C"
        tft.Ptz3(15,1,tempformat.format(atemp),rt,gn,bl)  # Anzeigen des Temperaturwertes
        tempmVformat="{:3.0f}mV"
        tft.Ptz1(45,1,tempmVformat.format(dtemp),rt,gn,bl)  # Anzeigen des Temperaturwertes
        
        if ((flag1==1) and (flag1old==0)):   # Einschaltflanke des Ventilators 1
            tft.Fra(244,170,36,20,255,255,0) # Gelbe Fläche für Ven1
            tft.Ptx2(250,172,"V1",0,0,0)
        if ((flag1==0) and (flag1old==1)):   # Ausschaltflanke des Ventilators 1
            tft.Fra(244,170,36,20,0,0,0)
        if ((flag2==1) and (flag2old==0)):   # Einschaltflanke des Ventilators 2
            tft.Fra(280,170,36,20,255,0,0)   # Rote Fläche für Ven2
            tft.Ptx2(286,172,"V2",0,0,0)
        if ((flag2==0) and (flag2old==1)):   # Ausschaltflanke des Ventilators 2
            tft.Fra(280,170,36,20,0,0,0)
        
        
        
        
        flag1old=flag1     # Merke den vorherigen Zustand des Ventilators 1
        flag2old=flag2
        dtempold=dtemp
        flagtemp=0
    
    
    
    
  








